// cpuload.cpp : Defines the entry point for the DLL application.
//
#include "Winuser.h"
#include "stdafx.h"
#include "shellapi.h"
#include "resource.h"
#include "cpuusage.h"
#include <math.h>
int timerID=4400;
int TRAY_CALLBACK=4666; 

HINSTANCE hinstDLLl;
lppatt_proc Main_Proc;
HWND MainWin;
HWND MetterWindow;
int is_started=0;
HICON icons[14];
NOTIFYICONDATA tnd;    
CCpuUsage usageA;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    hinstDLLl=(HINSTANCE)hModule;
	return TRUE;
}

void APIENTRY get_plug_info(PPlugInfo Data) {
	strcpy(Data->Menu_Text,"CPU Load meter");
	Data->PluginType=PL_RunTime;
	Data->Sign=ATT_Sign;
}


/*
BOOL CALLBACK MyDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HWND hwndList = GetDlgItem(hwndDlg, IDC_LIST1); 
	//LV_ITEM lvI;
									  
	bool result=false;
	switch (uMsg) {
	    case WM_INITDIALOG:	 
			break;
		case WM_CLOSE: 
				EndDialog(hwndDlg,0);
				result=true;
				break;
		case WM_COMMAND:
			switch (LOWORD(wParam))  { 
			case IDOK:  
					EndDialog(hwndDlg,0); 
					result=true; 

			} 
		case WM_KEYDOWN:
			if (wParam==2) {
				EndDialog(hwndDlg,0);
				result=true;				
			}

		break;
	}
	return result;
	
}
*/
LRESULT CALLBACK WindowProc( HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam )  {

	switch (uMsg) {		  
	
	case WM_CREATE:

				return 0;
				break;
    
	default:

		return (DefWindowProc(hwnd, uMsg, wParam, lParam));
	}
	
}
VOID CALLBACK TimerProc(
  HWND hwnd,         // handle to window
  UINT uMsg,         // WM_TIMER message
  UINT_PTR idEvent,  // timer identifier
  DWORD dwTime       // current system time
  ) {
		int SystemWideCpuUsage = usageA.GetCpuUsage();
		int curid=0;
		NOTIFYICONDATA tnd2;
		tnd2.uID = 4666;
		tnd2.cbSize = sizeof (NOTIFYICONDATA);
		tnd2.hWnd = MetterWindow;
	
		curid=(int)ceil(SystemWideCpuUsage / 6.66);
		if (curid>14) { curid=14; }
		tnd2.hIcon = icons[curid];
		tnd2.uFlags = NIF_ICON | NIF_TIP;
		sprintf(tnd2.szTip,"Cpu Usage : %d%%",SystemWideCpuUsage);
		Shell_NotifyIcon (NIM_MODIFY , &tnd2);

}



void APIENTRY exec_plugin (HWND Win_Handle, lppatt_proc ATT_Proc) {
	if (is_started==1) return;
	Main_Proc=ATT_Proc;
	MainWin=Win_Handle;
	is_started=1;
	//
	for (int i=0; i<15;i++) {
	icons[i]= LoadIcon(hinstDLLl,MAKEINTRESOURCE(102+i));
	}
	WNDCLASSEX wcexMain;
	wcexMain.cbSize = sizeof(WNDCLASSEX); 
	wcexMain.style = CS_HREDRAW | CS_VREDRAW;
	wcexMain.lpfnWndProc = WindowProc;
	wcexMain.cbClsExtra = 0;
	wcexMain.cbWndExtra = 0;
	wcexMain.hInstance = hinstDLLl;
	wcexMain.hIcon = 0;
	wcexMain.hCursor = 0;
	wcexMain.hbrBackground = 0;
	wcexMain.lpszMenuName = NULL;
	wcexMain.lpszClassName = "MainCPULoad";
	wcexMain.hIconSm = 0;
	if (!RegisterClassEx(&wcexMain)) {
		return ;
	}
	MetterWindow = CreateWindow("MainCPULoad", NULL, 0, CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hinstDLLl, NULL);
	//Set Tray ICON
	tnd.uID = 4666;
	tnd.cbSize = sizeof (NOTIFYICONDATA);
	tnd.hWnd = MetterWindow;
	tnd.uCallbackMessage = TRAY_CALLBACK;
	tnd.hIcon = icons[5];
	
	tnd.uFlags = NIF_MESSAGE | NIF_ICON;
	Shell_NotifyIcon (NIM_ADD, &tnd);

	SetTimer(MetterWindow,timerID,500,(TIMERPROC)TimerProc);

}

void APIENTRY done_plugin() {
	if (!is_started==1) return;
	KillTimer(MetterWindow,timerID);

	Shell_NotifyIcon (NIM_DELETE, &tnd);
	DestroyWindow(MetterWindow);
	UnregisterClass("MainCPULoad",hinstDLLl);
	is_started=0;
}

void APIENTRY config_plugin(HWND Win_Handle, lppatt_proc ATT_Proc) {
  
}
void APIENTRY suspend_restore() {
	
}